﻿/**
.______                                                              __          ___     
/\__  _\                                                           /'__`\      /'___`\   
\/_/\ \/  __  __  __     __      __     ___      ____   __  __    /\ \/\ \    /\_\ /\ \  
...\ \ \ /\ \/\ \/\ \  /'__`\  /'__`\ /' _ `\   /',__\ /\ \/\ \   \ \ \ \ \   \/_/// /__ 
....\ \ \\ \ \_/ \_/ \/\  __/ /\  __/ /\ \/\ \ /\__, `\\ \ \_\ \   \ \ \_\ \ __  // /_\ \
.....\ \_\\ \___x___/'\ \____\\ \____\\ \_\ \_\\/\____/ \/`____ \   \ \____//\_\/\______/
......\/_/ \/__//__/   \/____/ \/____/ \/_/\/_/ \/___/   `/___/> \   \/___/ \/_/\/_____/ 
............................................................/\___/                       
............................................................\/__/
................. Tweening since 1998 ......................
............................................................
 */
package com.flashdynamix.motion.plugins {
	import flash.display.DisplayObject;
	import flash.display.MovieClip;
	import flash.filters.BitmapFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.media.SoundTransform;
	import flash.utils.Dictionary;
	
	import com.flashdynamix.motion.TweensyGroup;
	import com.flashdynamix.utils.MultiTypeObjectPool;	

	/**
	 * @author FlashDynamix
	 */
	public class TweensyPluginList {

		private static var pool : MultiTypeObjectPool;
		private static var list : Array;
		private static var map : Dictionary;

		protected static var inited : Boolean = init();

		private static function init() : Boolean {
			if(inited) return true;
			
			list = [];
			map = new Dictionary(true);
			pool = new MultiTypeObjectPool();
			
			add(MovieClip, MovieClipTween);
			add(DisplayObject, DisplayTween);
			add(ColorTransform, ColorTween);
			add(BitmapFilter, FilterTween);
			add(Matrix, MatrixTween);
			add(SoundTransform, SoundTween);
			add(Object, ObjectTween);
			
			FilterTween.filters = TweensyGroup.filters;
			
			return true;
		}

		public static function add(Type : Class, Tween : Class) : void {
			list.push(Type);
			map[Type] = Tween;
			pool.add(Tween);
		}

		public static function checkOut(item : Object) : AbstractTween {
			var i : int;
			var len : int = list.length - 1;
			var Type : Class;
			
			for(i = 0;i < len; i++) {
				Type = list[i];
				if(item is Type) return pool.checkOut(map[Type]);
			}
			
			return pool.checkOut(map[list[len]]);
		}

		public static function checkIn(item : Object) : void {
			pool.checkIn(item);
		}

		public static function empty() : void {
			pool.empty();
		}
	}
}